function getType(url) {
  if (/\.js$/.test(url)) {
    return 'js'
  } else if (/\.css$/.test(url)) {
    return 'css'
  }
}

function inject(data, type) {
  switch (type) {
    case 'js': {
      eval(data)
      break
    }
    case 'css': {
      var head = document.getElementsByTagName('head')[0]
      var css = document.createElement('style')
      css.innerHTML = data
      head.appendChild(css)
      break
    }
  }
}

function getHash(str) {
  var hash = 0, i, chr, len
  if (str.length === 0) return hash
  for (i = 0, len = str.length; i < len; i++) {
    chr   = str.charCodeAt(i)
    hash  = ((hash << 5) - hash) + chr
    hash |= 0
  }
  return hash
}

function request(url, cb) {
  var req = new XMLHttpRequest()
  var error = function () {
    cb(new Error('Can\'t connect to PS Tunnel.'))
  }

  req.open('GET', url, true)
  req.onload = function () {
    var url = req.responseURL
    if (req.status === 200) {
      cb(null, req.responseText)
    } else {
      error()
    }
  }

  req.onerror = error
  req.send()
}

window.localOffline = function (urls, config) {
  var lastUpdate = new Date(localStorage.getItem('lo-lastupdate'))
  var shouldUpdate = ((new Date) - lastUpdate) > 15 * 60 * 1000
  if (shouldUpdate) {
    localStorage.setItem('lo-lastupdate', new Date)
  }

  urls.forEach(function (url) {
    var type = getType(url)
    var hash = getHash(url)

    var file = localStorage.getItem(hash)
    var isFile = !(!file || file === 'null')

    if (isFile) {
      inject(file, type)
    }

    if (shouldUpdate || !isFile) {
      request(url, function(err, data) {
        if (err) {
          return
        }
        if (!isFile) {
          inject(data, type)
        }
        localStorage.setItem(hash, data)
      })
    }
  })
}
